#!/bin/bash

VERSION=$(/vroot/bin/show microcode | grep "/flash" |cut -f3 -d'/' | cut -f1 -d'(')
OVNG_MONITORING="/bin/ovng-monitoring-agent"
OVNG_ONDEMAND="/bin/ovng-ondemand-agent"
OVNG_CONFIG="/bin/ovng-config-agent"
OVNG_MON_CFG="/flash/$VERSION/pkg/ovng-agent/ovng-mon-agent.cfg"
OVNG_CON_CFG="/flash/$VERSION/pkg/ovng-agent/ovng-con-agent.cfg"
CON_BROKER_CFG="/flash/$VERSION/pkg/ovng-agent/con-broker.cfg"
MON_BROKER_CFG="/flash/$VERSION/pkg/ovng-agent/mon-broker.cfg"

/usr/bin/logger -t "ovng" "$1 $2"
case $1 in
    start)
        case $2 in
            monitoring-agent)
                if [[ ! -s "$OVNG_MONITORING" ]]; then
                    /usr/bin/logger -t "ovng" "$OVNG_MONITORING not found"
                    echo "OVNG-Agent: $OVNG_MONITORING not found"
                    exit 1
                fi
                if [[ ! -s "$OVNG_ONDEMAND" ]]; then
                    /usr/bin/logger -t "ovng" "$OVNG_ONDEMAND not found"
                    echo "OVNG-Agent: $OVNG_ONDEMAND not found"
                    exit 1
                fi

                if [[ ! -s "$OVNG_MON_CFG" ]]; then
                    /usr/bin/logger -t "ovng" "$OVNG_MON_CFG not found or empty"
                    echo "OVNG-Agent: $OVNG_MON_CFG not found or empty"
                    exit 1
                fi

                if [[ ! -s "$MON_BROKER_CFG" ]]; then
                    /usr/bin/logger -t "ovng" "$MON_BROKER_CFG not found or empty"
                    echo "OVNG-Agent: $MON_BROKER_CFG not found or empty"
                    exit 1
                fi
                debug_compress=0
                enhance=0
                #PARSING PARAMETERS
                if [ "$#" -gt 2 ]; then
                    shift 2
                    CFGS="$@"
                    
                    > "$MON_BROKER_CFG"

                    echo $CFGS | tr ',' '\n' > /tmp/brokertemp.cfg

                    debug_compress=0
                    enhance=0
                    while read line; do
                    if [[ $line == "debug on" ]]; then
                        debug_compress=$((debug_compress + 1))
                    elif [[ $line == "compress on" ]]; then
                        debug_compress=$((debug_compress + 2))
                    elif [[ $line == "enhance on" ]]; then
                        enhance="on"
                    elif [[ $line == "enhance off" ]]; then
                        enhance="off"
                    elif [[ $line == -* ]] || [[ $line == --* ]]; then
                        echo "$line" >> "$MON_BROKER_CFG"
                    fi
                    done < /tmp/brokertemp.cfg

                    rm /tmp/brokertemp.cfg
                else
                    CFGS=""
                fi

                PID=$(pgrep -f "$OVNG_MONITORING")
                if [[ -z "$PID" ]]; then
                    csstart_task --escalationType=0 --thirdParty --commandLine="python3 $OVNG_MONITORING $debug_compress $enhance"
                    if [[ $? -ne 0 ]]; then
                        /usr/bin/logger -t "ovng" "Failed to start $OVNG_MONITORING"
                        echo "OVNG-Agent: Failed to start $OVNG_MONITORING"
                        exit 1
                    fi
                fi
                sleep 2
                PID=$(pgrep -f "$OVNG_ONDEMAND")
                if [[ -z "$PID" ]]; then
                    csstart_task --escalationType=0 --thirdParty --commandLine="python3 $OVNG_ONDEMAND $debug_compress $enhance"
                    if [[ $? -ne 0 ]]; then
                        /usr/bin/logger -t "ovng" "Failed to start $OVNG_ONDEMAND"
                        echo "OVNG-Agent: Failed to start $OVNG_ONDEMAND"
                        exit 1
                    fi
                fi
                ;;

            config-agent)                
                if [[ ! -s "$OVNG_CONFIG" ]]; then
                    /usr/bin/logger -t "ovng" "$OVNG_CONFIG not found"
                    echo "OVNG-Agent: $OVNG_CONFIG not found"
                    exit 1
                fi

                if [[ ! -s "$OVNG_CON_CFG" ]]; then
                    /usr/bin/logger -t "ovng" "$OVNG_CON_CFG not found or empty"
                    echo "OVNG-Agent: $OVNG_CON_CFG not found or empty"
                    exit 1
                fi

                if [[ ! -s "$CON_BROKER_CFG" ]]; then
                    /usr/bin/logger -t "ovng" "$CON_BROKER_CFG not found or empty"
                    echo "OVNG-Agent: $CON_BROKER_CFG not found or empty"
                    exit 1
                fi
                debug=0
                #PARSING PARAMETERS
                if [ "$#" -gt 2 ]; then
                    shift 2
                    CFGS="$@"
                    
                    > "$CON_BROKER_CFG"

                    echo $CFGS | tr ',' '\n' > /tmp/brokertemp.cfg

                    debug=0

                    while read line; do
                    if [[ $line == "debug on" ]]; then
                        debug=$((debug + 1))
                    elif [[ $line == -* ]] || [[ $line == --* ]]; then
                        echo "$line" >> "$CON_BROKER_CFG"
                    fi
                    done < /tmp/brokertemp.cfg

                    rm /tmp/brokertemp.cfg
                else
                    CFGS=""
                fi

                PID=$(pgrep -f "$OVNG_CONFIG")
                if [[ -z "$PID" ]]; then
                    csstart_task --escalationType=0 --thirdParty --commandLine="python3 $OVNG_CONFIG $debug"
                    if [[ $? -ne 0 ]]; then
                        /usr/bin/logger -t "ovng" "Failed to start $OVNG_CONFIG"
                        echo "OVNG-Agent: Failed to start $OVNG_CONFIG"
                        exit 1
                    fi
                fi
                ;;
            *)
                /usr/bin/logger -t "ovng" "Invalid ovng app"
                echo "OVNG-Agent: Invalid ovng app"
                exit 1
                ;;
        esac
        ;;

    stop)
        case $2 in
            monitoring-agent)
                PID=`pgrep -f "$OVNG_MONITORING"`
                if [[ ! -z "$PID" ]]; then
                    kill -SIGTERM $PID > /dev/null
                fi
                PID=`pgrep -f "$OVNG_ONDEMAND"`
                if [[ ! -z "$PID" ]]; then
                    kill -SIGTERM $PID > /dev/null
                fi
                ;;
            
            config-agent)
                PID=`pgrep -f "$OVNG_CONFIG"`
                if [[ ! -z "$PID" ]]; then
                    kill -SIGTERM $PID > /dev/null
                fi
                ;;
            *)
                /usr/bin/logger -t "ovng" "Invalid ovng app"
                echo "OVNG-Agent: Invalid ovng app"
                exit 1
                ;;
        esac
        ;;

    restart)
        case $2 in
            monitoring-agent)
                $0 stop monitoring-agent
                sleep 2
                $0 start monitoring-agent
                ;;
            
            config-agent)
                $0 stop config-agent
                sleep 2
                $0 start config-agent
                ;;
            *)
                /usr/bin/logger -t "ovng" "Invalid ovng app"
                echo "OVNG-Agent: Invalid ovng app"
                exit 1
                ;;
        esac
        ;;
    *)
        /usr/bin/logger -t "ovng" "Invalid action"
        echo "OVNG-Agent: Invalid action"
        exit 1
        ;;
esac
